package com.vf106.tools.utils;


import android.content.Context;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.util.Log;

import java.util.Locale;

import static android.speech.tts.TextToSpeech.Engine.KEY_PARAM_VOLUME;

public class TtsManager {

    private static volatile TtsManager instance;
    private final TextToSpeech mTts;

    public static TtsManager getInstance(Context context) {
        if (instance == null) {
            synchronized (TtsManager.class) {
                if (instance == null) {
                    instance = new TtsManager(context);
                }
            }
        }
        return instance;
    }

    private TtsManager(Context context) {
        mTts = new TextToSpeech(context, new TextToSpeech.OnInitListener() {
            @Override
            public void onInit(int status) {
                if (status == TextToSpeech.SUCCESS) {
                    int result = mTts.setLanguage(Locale.CHINA);
                    if (result == TextToSpeech.LANG_MISSING_DATA ||
                            result == TextToSpeech.LANG_NOT_SUPPORTED
                    ) {
                        Log.i("onInit", "Language data is missing or the language is not supported");
                    } else {
                        Log.i("onInit", "Language Activation Success");
                    }
                } else {
                    Log.e("onInit", "Initialization failure");
                }
            }
        });
    }

    public void say(Context context, String sayString) {
        Bundle bundle = new Bundle();
        bundle.putFloat(KEY_PARAM_VOLUME, 1.0f);
        mTts.speak("!" + sayString, TextToSpeech.QUEUE_ADD, bundle, null);
    }

    public void say(String sayString) {
//        mTts.setSpeechRate(1.5f);
        mTts.speak("!" + sayString, TextToSpeech.QUEUE_ADD, null);
    }

    public void release() {
        if (mTts != null) {
            mTts.stop();
            mTts.shutdown();
        }
    }
}